﻿#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Contact: alan.transon@gmail.com

import time,codecs,math,os,unicodedata
from aqt import mw
from anki.js import jquery
from aqt.utils import showInfo
from anki.utils import ids2str
from anki.hooks import addHook
from aqt.webview import AnkiWebView
from aqt.qt import *


################## Following section was taken from KanjiGrid plugin ###########################
#_time = None
_ignore = u"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz" + \
		  u"ＡＢＣＤＥＦＧＨＩＪＫＬＭＮＯＰＱＲＳＴＵＶＷＸＹＺ" + \
		  u"ａｂｃｄｅｆｇｈｉｊｋｌｍｎｏｐｑｒｓｔｕｖｗｘｙｚ" + \
		  u"1234567890１２３４５６７８９０" + \
		  u"あいうゔえおぁぃぅぇぉかきくけこがぎぐげごさしすせそざじずぜぞ" + \
		  u"たちつてとだぢづでどなにぬねのはひふへほばびぶべぼぱぴぷぺぽ" + \
		  u"まみむめもやゃゆゅよょらりるれろわをんっ" + \
		  u"アイウヴエオァィゥェォカキクケコガギグゲゴサシスセソザジズゼゾ" + \
		  u"タチツテトダヂヅデドナニヌネノハヒフヘホバビブベボパピプペポ" + \
		  u"マミムメモヤャユュヨョラリルレロワヲンッ" + \
		  u"!\"$%&'()|=~-^@[;:],./`{+*}<>?\\_" + \
		  u"＠「；：」、。・‘｛＋＊｝＜＞？＼＿！”＃＄％＆’（）｜＝．〜～ー＾ ゙゙゚" + \
		  u"☆★＊○●◎〇◯“…『』#♪ﾞ〉〈→》《π×"

def isKanji(unichar):
	try:
		return unicodedata.name(unichar).find('CJK UNIFIED IDEOGRAPH') >= 0
	except ValueError:
		# a control character
		return False
		
################## End of section taken from KanjiGrid plugin		###########################


class VocabularyLinker:
	def __init__(self, mw):
		if mw:
			self.menuAction = QAction("Link Kanji knowledge to vocabulary deck", mw)
			mw.connect(self.menuAction, SIGNAL("triggered()"), self.setup)
			mw.form.menuTools.addAction(self.menuAction)
			
		# Fields used in the Qt form
		self.kanjiDeck = None
		self.vocDeck = None
		self.vocFields = {}
		self.kanjiFields = {}
		
	def editCards(self):
		# Retrieving values
		self.kanjiDeck = mw.col.decks.byName(self.kanjiDeck.currentText())
		self.vocDeck = mw.col.decks.byName(self.vocDeck.currentText())
		for key, item in self.kanjiFields.items():
			self.kanjiFields[key] = item.text().strip()
		for key, item in self.vocFields.items():
			self.vocFields[key] = item.text().strip()
		
		# Selection of kanji cards IDs
		kanjiDids = [self.kanjiDeck['id']]
		for name, id in mw.col.decks.children(self.kanjiDeck['id']):
			kanjiDids.append(id)
		kanjiCids = mw.col.db.list("select id from cards where did in %s or odid in %s" % (ids2str(kanjiDids),ids2str(kanjiDids)))
		
        # Selection of vocabulary cards IDs
		vocDids = [self.vocDeck['id']]
		for name, id in mw.col.decks.children(self.vocDeck['id']):
			vocDids.append(id)
		vocCids = mw.col.db.list("select id from cards where did in %s or odid in %s" % (ids2str(vocDids),ids2str(vocDids)))
		
		knownKanjis = {}
		for i in kanjiCids:
			card = mw.col.getCard(i)
			if card.type > 0:
				kanjis = card.note()[self.kanjiFields["kanji"]]
				for char in kanjis:
					if _ignore.find(char) == -1 and isKanji(char):
						knownKanjis[char] = True
			
		
		for i in vocCids:
			card = mw.col.getCard(i)
			note = card.note()
			
			currentLevel = note[self.vocFields["kanjiLevel"]]
			currentLevel = 0 if (currentLevel == "") else float(currentLevel)
			newLevel = 0
			
			word = note[self.vocFields["kanji"]].replace(u"[五段]", "").replace(u"[一段]", "")
			nbKanjiInWord = 0
			for char in word:
				if _ignore.find(char) == -1 and isKanji(char):
					nbKanjiInWord += 1	
					if char in knownKanjis:
						newLevel += 1				
			
			if(nbKanjiInWord > 0):
				note[self.vocFields["kanjiLevel"]] = str(float(newLevel) / float(nbKanjiInWord))
			else:
				note[self.vocFields["kanjiLevel"]] = "-1"
			
			try:
				note["isReadingTraining"] = ""
				# Tag card with all kanji known
				if newLevel == nbKanjiInWord and nbKanjiInWord > 0 and card.type == 0 and card.queue == -1: # if it has not yet been seen and it is suspended
					note["isReadingTraining"] = "1"
			except KeyError:
				# If the field does not exist do nothing
				pass
			
			note.flush()		
		
		
	def setup(self):
		swin = QDialog(mw)
		vl = QVBoxLayout()
		frm = QGroupBox("Link kanji knowledge to vocabulary deck")
		vl.addWidget(frm)
		il = QVBoxLayout()
		
		self.kanjiDeck = QComboBox()
		self.kanjiDeck.addItems(mw.col.decks.allNames())
		il.addWidget(QLabel("Kanji deck to be used"))
		il.addWidget(self.kanjiDeck)
		
		self.kanjiFields["kanji"] = QLineEdit()
		self.kanjiFields["kanji"].setPlaceholderText("e.g. \"Kanji\"")
		il.addWidget(QLabel("Field name containing the kanji"))
		il.addWidget(self.kanjiFields["kanji"])
		
		self.vocDeck = QComboBox()
		self.vocDeck.addItems(mw.col.decks.allNames())
		il.addWidget(QLabel("Vocabulary deck to be modified"))
		il.addWidget(self.vocDeck)
		
		self.vocFields["kanji"] = QLineEdit()
		self.vocFields["kanji"].setPlaceholderText("e.g. \"Kanji\"")
		il.addWidget(QLabel("Field name containing the vocabulary in kanji"))
		il.addWidget(self.vocFields["kanji"])
		
		self.vocFields["kanjiLevel"] = QLineEdit()
		self.vocFields["kanjiLevel"].setPlaceholderText("e.g. \"KanjiLevel\"")
		il.addWidget(QLabel("Field name containing the proportion of kanjis known"))
		il.addWidget(self.vocFields["kanjiLevel"])
		
		frm.setLayout(il)
		hl = QHBoxLayout()
		vl.addLayout(hl)
		
		gen = QPushButton("Process")
		hl.addWidget(gen)
		gen.connect(gen, SIGNAL("clicked()"), swin, SLOT("accept()"))
		cls = QPushButton("Close")
		hl.addWidget(cls)
		cls.connect(cls, SIGNAL("clicked()"), swin, SLOT("reject()"))
		
		swin.setLayout(vl)
		swin.setTabOrder(gen,cls)
		swin.setTabOrder(cls,self.kanjiDeck)
		swin.setTabOrder(self.kanjiDeck, self.kanjiFields["kanji"])
		swin.setTabOrder(self.kanjiFields["kanji"], self.vocDeck)
		swin.setTabOrder(self.vocDeck, self.vocFields["kanji"])
		swin.setTabOrder(self.vocFields["kanji"], self.vocFields["kanjiLevel"])
		
		swin.resize(500, 400)
		if swin.exec_():
			mw.progress.start(immediate=True)
			
			errorCount = 0
			for key, item in self.kanjiFields.items():
				if len(item.text().strip()) == 0: 
					errorCount += 1
			
			for key, item in self.vocFields.items():
				if len(item.text().strip()) == 0: 
					errorCount += 1
					
			#if errorCount > 0:
			if False:
				showInfo("Error : %d fields empty" % errorCount)
			else:
				self.editCards()
				
			mw.progress.finish()

if __name__ != "__main__":
	# Save a reference to the toolkit onto the mw, preventing garbage collection of PyQT objects
	if mw: mw.vocabularyLinker = VocabularyLinker(mw)
else:
	print "This is a plugin for the Anki Spaced Repition learning system and cannot be run directly."
	print "Please download Anki2 from <http://ankisrs.net/>"

# vim:expandtab:
